/*
 *  file gamma_factory.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  ProductA?



class ProductA
{
public:
  virtual void echo() const = 0;
};



class ProductA1 : public ProductA
{
public:
  virtual void echo() const
    {
      std::cout << "ProductA1" << std::endl;
    }
};



class ProductA2 : public ProductA
{
public:
  virtual void echo() const
    {
      std::cout << "ProductA2" << std::endl;
    }
};



// --------------------------  ProductB?



class ProductB
{
public:
  virtual void echo() const = 0;
};



class ProductB1 : public ProductB
{
public:
  virtual void echo() const
    {
      std::cout << "ProductB1" << std::endl;
    }
};



class ProductB2 : public ProductB
{
public:
  virtual void echo() const
    {
      std::cout << "ProductB2" << std::endl;
    }
};



// --------------------------  AbstractFactory



class AbstractFactory
{
public:
  virtual ProductA& CreateProductA() = 0;
  virtual ProductB& CreateProductB() = 0;
};



// --------------------------  ConcreteFactory1



class ConcreteFactory1 : public AbstractFactory
{
public:
  virtual ProductA& CreateProductA()
    {
      return *new ProductA1();
    }
  virtual ProductB& CreateProductB()
    {
      return *new ProductB1();
    }
};



// --------------------------  ConcreteFactory2



class ConcreteFactory2 : public AbstractFactory
{
public:
  virtual ProductA& CreateProductA()
    {
      return *new ProductA2();
    }
  virtual ProductB& CreateProductB()
    {
      return *new ProductB2();
    }
};



// --------------------------  foo



void foo( AbstractFactory& factory )
{
  ProductA& a = factory.CreateProductA();
  a.echo();
}



// --------------------------  main



int main()
{
  ConcreteFactory2 factory;
  foo( factory );
}
