/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorate;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileMinWidth
extends FtileDecorate {
    private final double minWidth;
    private FtileGeometry calculateDimensionInternal;

    public FtileMinWidth(Ftile tile, double minWidth) {
        super(tile);
        this.minWidth = minWidth;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UTranslate change = this.getUTranslateInternal(stringBounder);
        super.drawU(ug.apply(change));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimensionInternal == null) {
            this.calculateDimensionInternal = this.calculateDimensionSlow(stringBounder);
        }
        return this.calculateDimensionInternal;
    }

    private FtileGeometry calculateDimensionSlow(StringBounder stringBounder) {
        FtileGeometry geo = super.calculateDimension(stringBounder);
        double left = this.getPoint2(geo.getLeft(), stringBounder);
        if (!geo.hasPointOut()) {
            return new FtileGeometry(this.getDimensionInternal(stringBounder), left, geo.getInY());
        }
        return new FtileGeometry(this.getDimensionInternal(stringBounder), left, geo.getInY(), geo.getOutY());
    }

    private Dimension2D getDimensionInternal(StringBounder stringBounder) {
        FtileGeometry dim = this.getFtileDelegated().calculateDimension(stringBounder);
        if (((Dimension2D)dim).getWidth() < this.minWidth) {
            return new Dimension2DDouble(this.minWidth, ((Dimension2D)dim).getHeight());
        }
        return dim;
    }

    private UTranslate getUTranslateInternal(StringBounder stringBounder) {
        FtileGeometry dimTile = this.getFtileDelegated().calculateDimension(stringBounder);
        Dimension2D dimTotal = this.getDimensionInternal(stringBounder);
        UTranslate change = new UTranslate((dimTotal.getWidth() - ((Dimension2D)dimTile).getWidth()) / 2.0, 0.0);
        return change;
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.getFtileDelegated()) {
            return this.getUTranslateInternal(stringBounder);
        }
        return null;
    }

    private double getPoint2(double x, StringBounder stringBounder) {
        FtileGeometry dim = this.getFtileDelegated().calculateDimension(stringBounder);
        if (((Dimension2D)dim).getWidth() < this.minWidth) {
            double diff = this.minWidth - ((Dimension2D)dim).getWidth();
            return x + diff / 2.0;
        }
        return x;
    }
}

