/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sourceforge.plantuml.AFile;
import net.sourceforge.plantuml.AFileRegular;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ImportedFiles;

public class FileWithSuffix {
    private final AFile file;
    private final String suffix;
    private final String entry;
    private final String description;

    public Reader getReader(String charset) throws IOException {
        if (this.entry == null) {
            if (charset == null) {
                Log.info("Using default charset");
                return new InputStreamReader(this.file.open());
            }
            Log.info("Using charset " + charset);
            return new InputStreamReader(this.file.open(), charset);
        }
        InputStream is = this.getDataFromZip(this.file.open(), this.entry);
        if (is == null) {
            return null;
        }
        if (charset == null) {
            Log.info("Using default charset");
            return new InputStreamReader(is);
        }
        Log.info("Using charset " + charset);
        return new InputStreamReader(is, charset);
    }

    private InputStream getDataFromZip(InputStream is, String name) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            if (!ze.isDirectory() && fileName.equals(name)) {
                return zis;
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return null;
    }

    public boolean fileOk() {
        return this.file != null && this.file.isOk();
    }

    FileWithSuffix(File file, String suffix) {
        this.file = new AFileRegular(file);
        this.suffix = suffix;
        this.entry = null;
        this.description = FileWithSuffix.getFileName(file);
    }

    public static String getFileName(File file) {
        return file.getName();
    }

    public static String getAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    public FileWithSuffix(ImportedFiles importedFiles, String fileName, String suffix) throws IOException {
        int idx = fileName.indexOf(126);
        this.suffix = suffix;
        if (idx == -1) {
            this.file = importedFiles.getAFile(fileName);
            this.entry = null;
        } else {
            this.file = importedFiles.getAFile(fileName.substring(0, idx));
            this.entry = fileName.substring(idx + 1);
        }
        this.description = this.file == null ? fileName : (this.entry == null ? fileName : fileName);
    }

    public int hashCode() {
        return (this.file == null ? 0 : this.file.hashCode()) + (this.suffix == null ? 0 : this.suffix.hashCode() * 43) + (this.entry == null ? 0 : this.entry.hashCode());
    }

    public boolean equals(Object arg) {
        FileWithSuffix other = (FileWithSuffix)arg;
        return this.file.equals(other.file) && FileWithSuffix.equals(this.suffix, other.suffix) && FileWithSuffix.same(this.entry, other.entry);
    }

    private static boolean same(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        assert (s1 == null && s2 != null || s1 != null && s2 == null);
        return false;
    }

    public static Set<File> convert(Set<FileWithSuffix> all) {
        HashSet<File> result = new HashSet<File>();
        for (FileWithSuffix f : all) {
            result.add(f.file.getUnderlyingFile());
        }
        return result;
    }

    public AParentFolder getParentFile() {
        Log.info("Getting parent of " + this.file);
        Log.info("-->The parent is " + this.file.getParentFile());
        return this.file.getParentFile();
    }

    public String getDescription() {
        return this.description;
    }

    public final String getSuffix() {
        return this.suffix;
    }

    public String toStringDebug() {
        return this.file.getAbsolutePath();
    }
}

