/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleDefinition;

public class Reference
extends AbstractEvent
implements Event {
    private final List<Participant> participants;
    private final Url url;
    private final HtmlColor backColorGeneral;
    private final HtmlColor backColorElement;
    private final Display strings;
    private final Style style;

    public StyleDefinition getDefaultStyleDefinition() {
        return ComponentType.REFERENCE.getDefaultStyleDefinition();
    }

    public Style[] getUsedStyles() {
        return new Style[]{this.style};
    }

    public Reference(List<Participant> participants, Url url, Display strings, HtmlColor backColorGeneral, HtmlColor backColorElement, StyleBuilder styleBuilder) {
        this.participants = participants;
        this.url = url;
        this.strings = strings;
        this.backColorGeneral = backColorGeneral;
        this.backColorElement = backColorElement;
        this.style = this.getDefaultStyleDefinition().getMergedStyle(styleBuilder);
    }

    public List<Participant> getParticipant() {
        return Collections.unmodifiableList(this.participants);
    }

    public Display getStrings() {
        return this.strings;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.participants.contains(someone);
    }

    @Override
    public final Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Participant> it = this.participants.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getCode());
            if (!it.hasNext()) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public final HtmlColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    public final HtmlColor getBackColorElement() {
        return this.backColorElement;
    }
}

