
#include <iostream>
using std::cout;
using std::endl;




//
//  Point
//
//////////////////////////////////////////////////////////////////////


struct Point
{
  typedef Point This;

  Point(int x, int y) :
    x(x),
    y(y) {
  }
  bool operator==(const This& rhs) const {
    return x == rhs.x && y == rhs.y;
  }
protected:
  int x, y;
};



//
//  ColorPoint
//
//////////////////////////////////////////////////////////////////////


struct ColorPoint : public Point
{
  typedef ColorPoint This;
  typedef Point Super;

  ColorPoint(int x, int y, int c) :
    Super(x, y),
    c(c) {
  }
  bool operator==(const This& rhs) const {
    return Super::operator==(rhs) && c == rhs.c;
  }
protected:
  int c;
};



//
//  foo
//
//////////////////////////////////////////////////////////////////////


void foo(const Point& p1, const Point& p2) {
  cout << (p1 == p2 ? "true" : "false")
       << endl;
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main()
{
  Point      a(0,5);
  ColorPoint b(0,5,1);
  foo(a, b);            // true!
}
