/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.EquivalenceClassFactory;
import owl.bdd.Factories;
import owl.bdd.FactorySupplier;
import owl.bdd.MtBdd;
import owl.bdd.MtBddOperations;
import owl.collections.BitSet2;
import owl.collections.Collections3;
import owl.collections.ImmutableBitSet;
import owl.collections.Pair;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.Formulas;
import owl.ltl.GOperator;
import owl.ltl.LabelledFormula;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Converter;
import owl.translations.BlockingElements;
import owl.translations.canonical.AutoValue_DeterministicConstructions_BreakpointStateAccepting;
import owl.translations.canonical.AutoValue_DeterministicConstructions_BreakpointStateAcceptingRoundRobin;
import owl.translations.canonical.AutoValue_DeterministicConstructions_BreakpointStateRejecting;
import owl.translations.canonical.AutoValue_DeterministicConstructions_BreakpointStateRejectingRoundRobin;
import owl.translations.canonical.RoundRobinState;
import owl.translations.canonical.Util;

public final class DeterministicConstructions {
    private static final boolean DISABLE_EXPENSIVE_ASSERT = true;

    private DeterministicConstructions() {
    }

    @AutoValue
    public static abstract class BreakpointStateRejectingRoundRobin {
        public abstract EquivalenceClass all();

        public abstract EquivalenceClass rejecting();

        public abstract Set<Formula.TemporalOperator> profile();

        public static BreakpointStateRejectingRoundRobin of(EquivalenceClass all) {
            Preconditions.checkArgument((all == all.unfold() ? 1 : 0) != 0);
            Preconditions.checkArgument((all.encoding() == EquivalenceClassFactory.Encoding.AP_COMBINED || !SyntacticFragments.isSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) && !SyntacticFragments.isCoSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) ? 1 : 0) != 0);
            EquivalenceClass accepting = all.factory().withDefaultEncoding(EquivalenceClassFactory.Encoding.AP_COMBINED).of(false);
            return new AutoValue_DeterministicConstructions_BreakpointStateRejectingRoundRobin(all, accepting, Set.of());
        }

        public static BreakpointStateRejectingRoundRobin of(EquivalenceClass all, EquivalenceClass rejecting, Set<Formula.TemporalOperator> profile) {
            Preconditions.checkArgument((all == all.unfold() ? 1 : 0) != 0);
            Preconditions.checkArgument((rejecting == rejecting.unfold() ? 1 : 0) != 0);
            Preconditions.checkArgument((all.encoding() == EquivalenceClassFactory.Encoding.AP_SEPARATE ? 1 : 0) != 0);
            Preconditions.checkArgument((!SyntacticFragments.isCoSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) ? 1 : 0) != 0);
            Preconditions.checkArgument((!SyntacticFragments.isSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) ? 1 : 0) != 0);
            Preconditions.checkArgument((rejecting.encoding() == EquivalenceClassFactory.Encoding.AP_COMBINED ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)SyntacticFragments.isCoSafety(rejecting));
            Preconditions.checkArgument((!rejecting.isTrue() || !rejecting.isFalse() ? 1 : 0) != 0, (Object)"Use of(EquivalenceClass all)");
            Preconditions.checkArgument((!profile.isEmpty() ? 1 : 0) != 0, (Object)"Use of(EquivalenceClass all)");
            Preconditions.checkArgument((boolean)rejecting.support(false).containsAll(profile));
            return new AutoValue_DeterministicConstructions_BreakpointStateRejectingRoundRobin(all, rejecting, Set.copyOf(profile));
        }

        public final BreakpointStateRejectingRoundRobin suspend() {
            return this.rejecting().isFalse() ? this : BreakpointStateRejectingRoundRobin.of(this.all());
        }

        public final String toString() {
            return String.format("BSRRR{all=%s, rejecting=%s, profile=%s}", this.all().conjunctiveNormalForm(), this.rejecting().isFalse() ? "[suspended]" : this.rejecting().conjunctiveNormalForm(), this.profile().isEmpty() ? "[suspended]" : this.profile());
        }
    }

    public static final class SafetyCoSafetyRoundRobin
    extends Base<BreakpointStateRejectingRoundRobin, BuchiAcceptance> {
        private static final PruneAcceptingStates PRUNE_ACCEPTING_STATES = new PruneAcceptingStates();
        private final SuspensionCheck suspensionCheck;
        private final boolean complete;
        private Map<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> profilesCache;

        private SafetyCoSafetyRoundRobin(Factories factories, BreakpointStateRejectingRoundRobin initialState, SuspensionCheck suspensionCheck, boolean complete, Map<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> profilesCache) {
            super(factories, initialState, BuchiAcceptance.INSTANCE);
            this.suspensionCheck = suspensionCheck;
            this.complete = complete;
            this.profilesCache = profilesCache;
        }

        public static SafetyCoSafetyRoundRobin of(LabelledFormula labelledFormula) {
            Factories factories = FactorySupplier.defaultSupplier().getFactories(labelledFormula.atomicPropositions(), EquivalenceClassFactory.Encoding.AP_SEPARATE);
            return SafetyCoSafetyRoundRobin.of(factories, labelledFormula.formula(), false, false);
        }

        public static SafetyCoSafetyRoundRobin of(Factories factories, Formula formula, boolean complete, boolean deactivateSuspensionCheckOnInitialFormula) {
            Preconditions.checkArgument((factories.eqFactory.defaultEncoding() == EquivalenceClassFactory.Encoding.AP_SEPARATE ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)SyntacticFragments.isSafetyCoSafety(formula));
            EquivalenceClass formulaClass = factories.eqFactory.of(formula);
            SuspensionCheck suspensionCheck = deactivateSuspensionCheckOnInitialFormula ? new SuspensionCheck() : new SuspensionCheck(formulaClass);
            IdentityHashMap<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> profilesCache = new IdentityHashMap<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>>();
            Edge<EquivalenceClass> allEdge = SafetyCoSafetyRoundRobin.allOnly(formulaClass, suspensionCheck);
            BreakpointStateRejectingRoundRobin initialState = allEdge == null ? SafetyCoSafetyRoundRobin.nextRejecting(formulaClass, Set.of(), profilesCache) : BreakpointStateRejectingRoundRobin.of(allEdge.successor());
            return new SafetyCoSafetyRoundRobin(factories, initialState, suspensionCheck, complete, profilesCache);
        }

        @Override
        protected void explorationCompleted() {
            this.profilesCache.clear();
            this.profilesCache = null;
            this.factory.clearCaches();
        }

        @Override
        public MtBdd<Edge<BreakpointStateRejectingRoundRobin>> edgeTreeImpl(BreakpointStateRejectingRoundRobin state) {
            return MtBddOperations.cartesianProduct(state.all().temporalStepTree(), state.rejecting().temporalStepTree(), (all, rejecting) -> this.edge(state.all(), (EquivalenceClass)all, (EquivalenceClass)rejecting, state.profile()));
        }

        @Nullable
        private Edge<BreakpointStateRejectingRoundRobin> edge(EquivalenceClass previousAll, EquivalenceClass all, EquivalenceClass rejecting, Set<Formula.TemporalOperator> profile) {
            Edge<EquivalenceClass> allUnfoldedEdge = SafetyCoSafetyRoundRobin.allOnly(all, this.suspensionCheck);
            if (allUnfoldedEdge != null) {
                if (!this.complete && allUnfoldedEdge.successor().isFalse()) {
                    return null;
                }
                return allUnfoldedEdge.mapSuccessor(BreakpointStateRejectingRoundRobin::of);
            }
            BreakpointStateRejectingRoundRobin nextRejecting = SafetyCoSafetyRoundRobin.nextRejecting(all, profile, this.profilesCache);
            if (nextRejecting.profile().isEmpty()) {
                return Edge.of(nextRejecting, 0);
            }
            if (profile.isEmpty() || BlockingElements.surelyContainedInDifferentSccs(previousAll, all.unfold())) {
                return Edge.of(nextRejecting);
            }
            EquivalenceClass rejectingUnfolded = SafetyCoSafetyRoundRobin.unfoldAndFilterAndUnfold(rejecting, profile);
            if (rejectingUnfolded.isTrue()) {
                return Edge.of(nextRejecting, 0);
            }
            return Edge.of(BreakpointStateRejectingRoundRobin.of(all.unfold(), rejectingUnfolded, profile));
        }

        @Nullable
        private static Edge<EquivalenceClass> allOnly(EquivalenceClass all, SuspensionCheck suspensionCheck) {
            EquivalenceClass allUnfolded = all.unfold();
            EquivalenceClass allUnfoldedWithCombinedAp = allUnfolded.encode(EquivalenceClassFactory.Encoding.AP_COMBINED).unfold();
            EquivalenceClassFactory combinedApFactory = allUnfoldedWithCombinedAp.factory();
            if (allUnfoldedWithCombinedAp.isTrue()) {
                return Edge.of(combinedApFactory.of(true), 0);
            }
            if (allUnfoldedWithCombinedAp.isFalse()) {
                return Edge.of(combinedApFactory.of(false));
            }
            if (suspensionCheck.isBlockedByTransient(allUnfolded)) {
                if (SyntacticFragments.isSafety(allUnfoldedWithCombinedAp) || SyntacticFragments.isCoSafety(allUnfoldedWithCombinedAp)) {
                    return Edge.of(allUnfoldedWithCombinedAp);
                }
                return Edge.of(allUnfolded);
            }
            if (suspensionCheck.isBlockedByCoSafety(allUnfolded)) {
                if (SyntacticFragments.isCoSafety(allUnfoldedWithCombinedAp)) {
                    return Edge.of(allUnfoldedWithCombinedAp);
                }
                return Edge.of(allUnfolded);
            }
            if (suspensionCheck.isBlockedBySafety(allUnfolded)) {
                if (SyntacticFragments.isSafety(allUnfoldedWithCombinedAp)) {
                    return Edge.of(allUnfoldedWithCombinedAp, 0);
                }
                return Edge.of(allUnfolded, 0);
            }
            return null;
        }

        private static EquivalenceClass unfoldAndFilterAndUnfold(EquivalenceClass rejecting, Set<Formula.TemporalOperator> profile) {
            return rejecting.factory().of(Conjunction.of(rejecting.unfold().conjunctiveNormalForm().stream().filter(clause -> clause.containsAll(profile)).map(Disjunction::of))).unfold();
        }

        private static BreakpointStateRejectingRoundRobin nextRejecting(EquivalenceClass all, Set<Formula.TemporalOperator> currentProfile, Map<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> rejectingRunsCache) {
            NavigableMap rejectingRuns = rejectingRunsCache.computeIfAbsent(SafetyCoSafetyRoundRobin.extractRunsInRejectingStates(all), SafetyCoSafetyRoundRobin::partitionRejectingRuns);
            Map.Entry tailEntry = rejectingRuns.higherEntry(currentProfile);
            if (tailEntry != null) {
                return BreakpointStateRejectingRoundRobin.of(all.unfold(), (EquivalenceClass)tailEntry.getValue(), tailEntry.getKey());
            }
            Map.Entry headEntry = rejectingRuns.headMap(currentProfile, true).firstEntry();
            if (headEntry != null) {
                return BreakpointStateRejectingRoundRobin.of(all.unfold(), (EquivalenceClass)headEntry.getValue(), headEntry.getKey());
            }
            return BreakpointStateRejectingRoundRobin.of(all.unfold());
        }

        private static EquivalenceClass extractRunsInRejectingStates(EquivalenceClass all) {
            HashSet<XOperator> protectedXOperators;
            EquivalenceClass rejecting = all.substitute(PRUNE_ACCEPTING_STATES);
            assert (SyntacticFragments.isCoSafety(rejecting));
            EquivalenceClass xRemovedRejecting = rejecting;
            do {
                rejecting = xRemovedRejecting;
                protectedXOperators = new HashSet<XOperator>();
                for (Formula formula : rejecting.support(false)) {
                    if (formula instanceof XOperator) continue;
                    assert (formula instanceof Literal || formula instanceof FOperator || formula instanceof UOperator || formula instanceof MOperator);
                    protectedXOperators.addAll(formula.subformulas(XOperator.class));
                }
            } while (!rejecting.equals(xRemovedRejecting = rejecting.substitute(x -> {
                if (x instanceof XOperator && !protectedXOperators.contains(x)) {
                    return BooleanConstant.TRUE;
                }
                return x;
            })));
            return xRemovedRejecting.unfold();
        }

        private static NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass> partitionRejectingRuns(EquivalenceClass rejecting) {
            TreeMap<Set<Formula.TemporalOperator>, EquivalenceClass> partition = new TreeMap<Set<Formula.TemporalOperator>, EquivalenceClass>(Formulas::compare);
            EquivalenceClassFactory factory = rejecting.factory();
            Preconditions.checkState((factory.defaultEncoding() == EquivalenceClassFactory.Encoding.AP_SEPARATE ? 1 : 0) != 0);
            EquivalenceClassFactory combinedFactory = factory.withDefaultEncoding(EquivalenceClassFactory.Encoding.AP_COMBINED);
            Preconditions.checkState((combinedFactory.defaultEncoding() == EquivalenceClassFactory.Encoding.AP_COMBINED ? 1 : 0) != 0);
            block0: for (Set<Formula> clause : rejecting.conjunctiveNormalForm()) {
                ArrayList<Formula.TemporalOperator> newProfile = new ArrayList<Formula.TemporalOperator>();
                for (Formula maximalElement : Collections3.maximalElements(clause, (x, y) -> y.anyMatch(x::equals))) {
                    if (maximalElement instanceof Literal || maximalElement instanceof XOperator) continue block0;
                    assert (maximalElement instanceof FOperator || maximalElement instanceof UOperator || maximalElement instanceof MOperator) : "CNF contained an unexpected element: " + maximalElement;
                    newProfile.add((Formula.TemporalOperator)maximalElement);
                }
                if (newProfile.isEmpty()) continue;
                partition.compute(Set.copyOf(newProfile), (key, oldValue) -> {
                    EquivalenceClass newValue = combinedFactory.of(Disjunction.of(clause));
                    return oldValue == null ? newValue : oldValue.and(newValue);
                });
            }
            Iterator entryIterator = partition.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                entry.setValue(SafetyCoSafetyRoundRobin.unfoldAndFilterAndUnfold((EquivalenceClass)entry.getValue(), (Set)entry.getKey()));
                if (!((EquivalenceClass)entry.getValue()).isTrue()) continue;
                entryIterator.remove();
            }
            return partition;
        }

        private static class PruneAcceptingStates
        extends Converter {
            private PruneAcceptingStates() {
                super(SyntacticFragment.NNF);
            }

            @Override
            public Formula visit(FOperator fOperator) {
                assert (SyntacticFragments.isCoSafety(fOperator));
                return fOperator;
            }

            @Override
            public Formula visit(GOperator gOperator) {
                if (SyntacticFragments.isSafety(gOperator)) {
                    return BooleanConstant.TRUE;
                }
                return gOperator.operand().accept(this);
            }

            @Override
            public Formula visit(MOperator mOperator) {
                assert (SyntacticFragments.isCoSafety(mOperator));
                return mOperator;
            }

            @Override
            public Formula visit(ROperator rOperator) {
                return rOperator.rightOperand().accept(this);
            }

            @Override
            public Formula visit(UOperator uOperator) {
                assert (SyntacticFragments.isCoSafety(uOperator));
                return uOperator;
            }

            @Override
            public Formula visit(WOperator wOperator) {
                return Disjunction.of(wOperator.leftOperand().accept(this), wOperator.rightOperand().accept(this));
            }

            @Override
            public Formula visit(XOperator xOperator) {
                if (SyntacticFragments.isCoSafety(xOperator)) {
                    return xOperator;
                }
                return BooleanConstant.TRUE;
            }
        }
    }

    @AutoValue
    public static abstract class BreakpointStateAcceptingRoundRobin {
        public abstract EquivalenceClass all();

        public abstract EquivalenceClass accepting();

        public abstract Set<Formula.TemporalOperator> profile();

        public static BreakpointStateAcceptingRoundRobin of(EquivalenceClass all) {
            Preconditions.checkArgument((all == all.unfold() ? 1 : 0) != 0);
            Preconditions.checkArgument((all.encoding() == EquivalenceClassFactory.Encoding.AP_COMBINED || !SyntacticFragments.isSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) && !SyntacticFragments.isCoSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) ? 1 : 0) != 0);
            EquivalenceClass accepting = all.factory().withDefaultEncoding(EquivalenceClassFactory.Encoding.AP_COMBINED).of(true);
            return new AutoValue_DeterministicConstructions_BreakpointStateAcceptingRoundRobin(all, accepting, Set.of());
        }

        public static BreakpointStateAcceptingRoundRobin of(EquivalenceClass all, EquivalenceClass accepting, Set<Formula.TemporalOperator> profile) {
            Preconditions.checkArgument((all == all.unfold() ? 1 : 0) != 0);
            Preconditions.checkArgument((accepting == accepting.unfold() ? 1 : 0) != 0);
            Preconditions.checkArgument((all.encoding() == EquivalenceClassFactory.Encoding.AP_SEPARATE ? 1 : 0) != 0);
            Preconditions.checkArgument((!SyntacticFragments.isCoSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) ? 1 : 0) != 0);
            Preconditions.checkArgument((!SyntacticFragments.isSafety(all.encode(EquivalenceClassFactory.Encoding.AP_COMBINED)) ? 1 : 0) != 0);
            Preconditions.checkArgument((accepting.encoding() == EquivalenceClassFactory.Encoding.AP_COMBINED ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)SyntacticFragments.isSafety(accepting));
            Preconditions.checkArgument((!accepting.isTrue() || !accepting.isFalse() ? 1 : 0) != 0, (Object)"Use of(EquivalenceClass all)");
            Preconditions.checkArgument((!profile.isEmpty() ? 1 : 0) != 0, (Object)"Use of(EquivalenceClass all)");
            Preconditions.checkArgument((boolean)accepting.support(false).containsAll(profile));
            return new AutoValue_DeterministicConstructions_BreakpointStateAcceptingRoundRobin(all, accepting, Set.copyOf(profile));
        }

        public final BreakpointStateAcceptingRoundRobin suspend() {
            return this.accepting().isTrue() ? this : BreakpointStateAcceptingRoundRobin.of(this.all());
        }

        public final String toString() {
            return String.format("BSARR{all=%s, accepting=%s, profile=%s}", this.all().disjunctiveNormalForm(), this.accepting().isTrue() ? "[suspended]" : this.accepting().disjunctiveNormalForm(), this.profile().isEmpty() ? "[suspended]" : this.profile());
        }
    }

    public static final class CoSafetySafetyRoundRobin
    extends Base<BreakpointStateAcceptingRoundRobin, CoBuchiAcceptance> {
        private static final PruneRejectingStates PRUNE_REJECTING_STATES = new PruneRejectingStates();
        private final SuspensionCheck suspensionCheck;
        private final boolean complete;
        private Map<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> profilesCache;

        private CoSafetySafetyRoundRobin(Factories factories, BreakpointStateAcceptingRoundRobin initialState, SuspensionCheck suspensionCheck, boolean complete, Map<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> profilesCache) {
            super(factories, initialState, CoBuchiAcceptance.INSTANCE);
            this.suspensionCheck = suspensionCheck;
            this.complete = complete;
            this.profilesCache = profilesCache;
        }

        public static CoSafetySafetyRoundRobin of(LabelledFormula labelledFormula) {
            Factories factories = FactorySupplier.defaultSupplier().getFactories(labelledFormula.atomicPropositions(), EquivalenceClassFactory.Encoding.AP_SEPARATE);
            return CoSafetySafetyRoundRobin.of(factories, labelledFormula.formula(), false, false);
        }

        public static CoSafetySafetyRoundRobin of(Factories factories, Formula formula, boolean complete, boolean deactivateSuspensionCheckOnInitialFormula) {
            Preconditions.checkArgument((factories.eqFactory.defaultEncoding() == EquivalenceClassFactory.Encoding.AP_SEPARATE ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)SyntacticFragments.isCoSafetySafety(formula));
            EquivalenceClass formulaClass = factories.eqFactory.of(formula);
            SuspensionCheck suspensionCheck = deactivateSuspensionCheckOnInitialFormula ? new SuspensionCheck() : new SuspensionCheck(formulaClass);
            IdentityHashMap<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> profilesCache = new IdentityHashMap<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>>();
            Edge<EquivalenceClass> allEdge = CoSafetySafetyRoundRobin.allOnly(formulaClass, suspensionCheck);
            BreakpointStateAcceptingRoundRobin initialState = allEdge == null ? CoSafetySafetyRoundRobin.nextAccepting(formulaClass, Set.of(), profilesCache) : BreakpointStateAcceptingRoundRobin.of(allEdge.successor());
            return new CoSafetySafetyRoundRobin(factories, initialState, suspensionCheck, complete, profilesCache);
        }

        @Override
        protected void explorationCompleted() {
            this.profilesCache.clear();
            this.profilesCache = null;
            this.factory.clearCaches();
        }

        @Override
        public MtBdd<Edge<BreakpointStateAcceptingRoundRobin>> edgeTreeImpl(BreakpointStateAcceptingRoundRobin state) {
            return MtBddOperations.cartesianProduct(state.all().temporalStepTree(), state.accepting().temporalStepTree(), (all, accepting) -> this.edge(state.all(), (EquivalenceClass)all, (EquivalenceClass)accepting, state.profile()));
        }

        @Nullable
        private Edge<BreakpointStateAcceptingRoundRobin> edge(EquivalenceClass previousAll, EquivalenceClass all, EquivalenceClass accepting, Set<Formula.TemporalOperator> profile) {
            Edge<EquivalenceClass> allUnfoldedEdge = CoSafetySafetyRoundRobin.allOnly(all, this.suspensionCheck);
            if (allUnfoldedEdge != null) {
                if (!this.complete && allUnfoldedEdge.successor().isFalse()) {
                    return null;
                }
                return allUnfoldedEdge.mapSuccessor(BreakpointStateAcceptingRoundRobin::of);
            }
            BreakpointStateAcceptingRoundRobin nextAccepting = CoSafetySafetyRoundRobin.nextAccepting(all, profile, this.profilesCache);
            if (profile.isEmpty() || nextAccepting.profile().isEmpty() || BlockingElements.surelyContainedInDifferentSccs(previousAll, all.unfold())) {
                return Edge.of(nextAccepting, 0);
            }
            EquivalenceClass acceptingUnfolded = CoSafetySafetyRoundRobin.unfoldAndFilterAndUnfold(accepting, profile);
            if (acceptingUnfolded.isFalse()) {
                return Edge.of(nextAccepting, 0);
            }
            return Edge.of(BreakpointStateAcceptingRoundRobin.of(all.unfold(), acceptingUnfolded, profile));
        }

        @Nullable
        private static Edge<EquivalenceClass> allOnly(EquivalenceClass all, SuspensionCheck suspensionCheck) {
            EquivalenceClass allUnfolded = all.unfold();
            EquivalenceClass allUnfoldedWithCombinedAp = allUnfolded.encode(EquivalenceClassFactory.Encoding.AP_COMBINED).unfold();
            EquivalenceClassFactory combinedApFactory = allUnfoldedWithCombinedAp.factory();
            if (allUnfoldedWithCombinedAp.isTrue()) {
                return Edge.of(combinedApFactory.of(true));
            }
            if (allUnfoldedWithCombinedAp.isFalse()) {
                return Edge.of(combinedApFactory.of(false), 0);
            }
            if (suspensionCheck.isBlockedByTransient(allUnfolded)) {
                if (SyntacticFragments.isSafety(allUnfoldedWithCombinedAp) || SyntacticFragments.isCoSafety(allUnfoldedWithCombinedAp)) {
                    return Edge.of(allUnfoldedWithCombinedAp, 0);
                }
                return Edge.of(allUnfolded, 0);
            }
            if (suspensionCheck.isBlockedByCoSafety(allUnfolded)) {
                if (SyntacticFragments.isCoSafety(allUnfoldedWithCombinedAp)) {
                    return Edge.of(allUnfoldedWithCombinedAp, 0);
                }
                return Edge.of(allUnfolded, 0);
            }
            if (suspensionCheck.isBlockedBySafety(allUnfolded)) {
                if (SyntacticFragments.isSafety(allUnfoldedWithCombinedAp)) {
                    return Edge.of(allUnfoldedWithCombinedAp);
                }
                return Edge.of(allUnfolded);
            }
            return null;
        }

        private static EquivalenceClass unfoldAndFilterAndUnfold(EquivalenceClass accepting, Set<Formula.TemporalOperator> profile) {
            return accepting.factory().of(Disjunction.of(accepting.unfold().disjunctiveNormalForm().stream().filter(clause -> clause.containsAll(profile)).map(Conjunction::of))).unfold();
        }

        private static BreakpointStateAcceptingRoundRobin nextAccepting(EquivalenceClass all, Set<Formula.TemporalOperator> currentProfile, Map<EquivalenceClass, NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass>> acceptingRunsCache) {
            NavigableMap acceptingRuns = acceptingRunsCache.computeIfAbsent(CoSafetySafetyRoundRobin.extractRunsInAcceptingStates(all), CoSafetySafetyRoundRobin::partitionAcceptingRuns);
            Map.Entry tailEntry = acceptingRuns.higherEntry(currentProfile);
            if (tailEntry != null) {
                return BreakpointStateAcceptingRoundRobin.of(all.unfold(), (EquivalenceClass)tailEntry.getValue(), tailEntry.getKey());
            }
            Map.Entry headEntry = acceptingRuns.headMap(currentProfile, true).firstEntry();
            if (headEntry != null) {
                return BreakpointStateAcceptingRoundRobin.of(all.unfold(), (EquivalenceClass)headEntry.getValue(), headEntry.getKey());
            }
            return BreakpointStateAcceptingRoundRobin.of(all.unfold());
        }

        private static EquivalenceClass extractRunsInAcceptingStates(EquivalenceClass all) {
            HashSet<XOperator> protectedXOperators;
            EquivalenceClass accepting = all.substitute(PRUNE_REJECTING_STATES);
            assert (SyntacticFragments.isSafety(accepting));
            EquivalenceClass xRemovedAccepting = accepting;
            do {
                accepting = xRemovedAccepting;
                protectedXOperators = new HashSet<XOperator>();
                for (Formula formula : accepting.support(false)) {
                    if (formula instanceof XOperator) continue;
                    assert (formula instanceof Literal || formula instanceof GOperator || formula instanceof WOperator || formula instanceof ROperator);
                    protectedXOperators.addAll(formula.subformulas(XOperator.class));
                }
            } while (!accepting.equals(xRemovedAccepting = accepting.substitute(x -> {
                if (x instanceof XOperator && !protectedXOperators.contains(x)) {
                    return BooleanConstant.FALSE;
                }
                return x;
            })));
            return xRemovedAccepting.unfold();
        }

        private static NavigableMap<Set<Formula.TemporalOperator>, EquivalenceClass> partitionAcceptingRuns(EquivalenceClass accepting) {
            TreeMap<Set<Formula.TemporalOperator>, EquivalenceClass> partition = new TreeMap<Set<Formula.TemporalOperator>, EquivalenceClass>(Formulas::compare);
            EquivalenceClassFactory factory = accepting.factory();
            Preconditions.checkState((factory.defaultEncoding() == EquivalenceClassFactory.Encoding.AP_SEPARATE ? 1 : 0) != 0);
            EquivalenceClassFactory combinedFactory = factory.withDefaultEncoding(EquivalenceClassFactory.Encoding.AP_COMBINED);
            Preconditions.checkState((combinedFactory.defaultEncoding() == EquivalenceClassFactory.Encoding.AP_COMBINED ? 1 : 0) != 0);
            block0: for (Set<Formula> clause : accepting.disjunctiveNormalForm()) {
                ArrayList<Formula.TemporalOperator> newProfile = new ArrayList<Formula.TemporalOperator>();
                for (Formula maximalElement : Collections3.maximalElements(clause, (x, y) -> y.anyMatch(x::equals))) {
                    if (maximalElement instanceof Literal || maximalElement instanceof XOperator) continue block0;
                    assert (maximalElement instanceof GOperator || maximalElement instanceof ROperator || maximalElement instanceof WOperator) : "DNF contained an unexpected element: " + maximalElement;
                    newProfile.add((Formula.TemporalOperator)maximalElement);
                }
                if (newProfile.isEmpty()) continue;
                partition.compute(Set.copyOf(newProfile), (key, oldValue) -> {
                    EquivalenceClass newValue = combinedFactory.of(Conjunction.of(clause));
                    return oldValue == null ? newValue : oldValue.or(newValue);
                });
            }
            Iterator entryIterator = partition.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                entry.setValue(CoSafetySafetyRoundRobin.unfoldAndFilterAndUnfold((EquivalenceClass)entry.getValue(), (Set)entry.getKey()));
                if (!((EquivalenceClass)entry.getValue()).isFalse()) continue;
                entryIterator.remove();
            }
            return partition;
        }

        private static class PruneRejectingStates
        extends Converter {
            private PruneRejectingStates() {
                super(SyntacticFragment.NNF);
            }

            @Override
            public Formula visit(FOperator fOperator) {
                if (SyntacticFragments.isCoSafety(fOperator)) {
                    return BooleanConstant.FALSE;
                }
                return fOperator.operand().accept(this);
            }

            @Override
            public Formula visit(GOperator gOperator) {
                assert (SyntacticFragments.isSafety(gOperator));
                return gOperator;
            }

            @Override
            public Formula visit(MOperator mOperator) {
                return Conjunction.of(mOperator.leftOperand().accept(this), mOperator.rightOperand().accept(this));
            }

            @Override
            public Formula visit(ROperator rOperator) {
                assert (SyntacticFragments.isSafety(rOperator));
                return rOperator;
            }

            @Override
            public Formula visit(UOperator uOperator) {
                return uOperator.rightOperand().accept(this);
            }

            @Override
            public Formula visit(WOperator wOperator) {
                assert (SyntacticFragments.isSafety(wOperator));
                return wOperator;
            }

            @Override
            public Formula visit(XOperator xOperator) {
                if (SyntacticFragments.isSafety(xOperator)) {
                    return xOperator;
                }
                return BooleanConstant.FALSE;
            }
        }
    }

    public static final class SuspensionCheck {
        private final Set<Formula.TemporalOperator> blockingCoSafety;
        private final Set<Formula.TemporalOperator> blockingSafety;
        private final Map<EquivalenceClass, Boolean> transientBlocked = new HashMap<EquivalenceClass, Boolean>();
        private final Map<EquivalenceClass, Boolean> safetyBlocked = new HashMap<EquivalenceClass, Boolean>();
        private final Map<EquivalenceClass, Boolean> coSafetyBlocked = new HashMap<EquivalenceClass, Boolean>();

        private SuspensionCheck() {
            this.blockingCoSafety = Set.of();
            this.blockingSafety = Set.of();
        }

        private SuspensionCheck(EquivalenceClass formulaClass) {
            this.blockingCoSafety = Set.copyOf(BlockingElements.blockingCoSafetyFormulas(formulaClass));
            this.blockingSafety = Set.copyOf(BlockingElements.blockingSafetyFormulas(formulaClass));
        }

        public boolean isBlocked(EquivalenceClass clazz) {
            return this.isBlockedByTransient(clazz) || this.isBlockedByCoSafety(clazz) || this.isBlockedBySafety(clazz);
        }

        public boolean isBlockedByCoSafety(EquivalenceClass clazz) {
            return this.coSafetyBlocked.computeIfAbsent(clazz, x -> !Collections.disjoint(x.temporalOperators(true), this.blockingCoSafety) || BlockingElements.isBlockedByCoSafety(x));
        }

        public boolean isBlockedBySafety(EquivalenceClass clazz) {
            return this.safetyBlocked.computeIfAbsent(clazz, x -> !Collections.disjoint(x.temporalOperators(true), this.blockingSafety) || BlockingElements.isBlockedBySafety(x));
        }

        public boolean isBlockedByTransient(EquivalenceClass clazz) {
            return this.transientBlocked.computeIfAbsent(clazz, BlockingElements::isBlockedByTransient);
        }
    }

    @AutoValue
    public static abstract class BreakpointStateRejecting {
        public abstract EquivalenceClass all();

        public abstract EquivalenceClass rejecting();

        public static BreakpointStateRejecting of(EquivalenceClass all) {
            return new AutoValue_DeterministicConstructions_BreakpointStateRejecting(all, all.factory().of(false));
        }

        public static BreakpointStateRejecting of(EquivalenceClass all, EquivalenceClass rejecting) {
            if (all.isFalse()) {
                Preconditions.checkArgument((boolean)rejecting.isFalse());
                return BreakpointStateRejecting.of(all.factory().of(false));
            }
            return new AutoValue_DeterministicConstructions_BreakpointStateRejecting(all, rejecting);
        }

        public final boolean isSuspended() {
            return this.rejecting().factory().of(false).equals(this.rejecting());
        }

        public final BreakpointStateRejecting suspend() {
            return this.rejecting().factory().of(false).equals(this.rejecting()) ? this : BreakpointStateRejecting.of(this.all());
        }

        public final String toString() {
            return String.format("BreakpointStateRejecting{all=%s, rejecting=%s}", this.all(), this.isSuspended() ? "[suspended]" : this.rejecting());
        }
    }

    public static final class SafetyCoSafety
    extends Base<BreakpointStateRejecting, BuchiAcceptance> {
        public final SuspensionCheck suspensionCheck;
        private final boolean complete;

        private SafetyCoSafety(Factories factories, BreakpointStateRejecting initialState, SuspensionCheck suspensionCheck, boolean complete) {
            super(factories, initialState, BuchiAcceptance.INSTANCE);
            this.suspensionCheck = suspensionCheck;
            this.complete = complete;
        }

        public static SafetyCoSafety of(LabelledFormula formula) {
            return SafetyCoSafety.of(FactorySupplier.defaultSupplier().getFactories(formula.atomicPropositions()), formula.formula());
        }

        public static SafetyCoSafety of(Factories factories, Formula formula) {
            return SafetyCoSafety.of(factories, formula, false, false);
        }

        public static SafetyCoSafety of(Factories factories, Formula formula, boolean complete, boolean deactivateSuspensionCheckOnInitialFormula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isSafetyCoSafety(formula));
            EquivalenceClass formulaClass = factories.eqFactory.of(formula);
            SuspensionCheck suspensionCheck = deactivateSuspensionCheckOnInitialFormula ? new SuspensionCheck() : new SuspensionCheck(formulaClass);
            return new SafetyCoSafety(factories, SafetyCoSafety.initialState(formulaClass, suspensionCheck), suspensionCheck, complete);
        }

        public BreakpointStateRejecting initialState(Formula formula) {
            return SafetyCoSafety.initialState(this.factory.of(formula), this.suspensionCheck);
        }

        private static BreakpointStateRejecting initialState(EquivalenceClass formulaClass, SuspensionCheck suspensionCheck) {
            if (suspensionCheck.isBlocked(formulaClass.unfold())) {
                return BreakpointStateRejecting.of(formulaClass.unfold());
            }
            return BreakpointStateRejecting.of(formulaClass.unfold(), SafetyCoSafety.rejecting(formulaClass));
        }

        @Override
        public MtBdd<Edge<BreakpointStateRejecting>> edgeTreeImpl(BreakpointStateRejecting state) {
            return MtBddOperations.cartesianProduct(state.all().temporalStepTree(), state.rejecting().temporalStepTree(), (all, rejecting) -> this.edge(state.all(), (EquivalenceClass)all, (EquivalenceClass)rejecting));
        }

        @Nullable
        private Edge<BreakpointStateRejecting> edge(EquivalenceClass previousAll, EquivalenceClass all, EquivalenceClass rejecting) {
            EquivalenceClass allUnfolded = all.unfold();
            if (allUnfolded.isFalse()) {
                return this.complete ? Edge.of(BreakpointStateRejecting.of(this.factory.of(false))) : null;
            }
            if (allUnfolded.isTrue()) {
                return Edge.of(BreakpointStateRejecting.of(this.factory.of(true)), 0);
            }
            if (this.suspensionCheck.isBlockedBySafety(allUnfolded)) {
                return Edge.of(BreakpointStateRejecting.of(allUnfolded), 0);
            }
            assert (!allUnfolded.isTrue());
            if (this.suspensionCheck.isBlockedByTransient(allUnfolded) || this.suspensionCheck.isBlockedByCoSafety(allUnfolded)) {
                return Edge.of(BreakpointStateRejecting.of(allUnfolded));
            }
            EquivalenceClass rejectingUnfolded = rejecting.unfold();
            if (rejectingUnfolded.isFalse() || BlockingElements.surelyContainedInDifferentSccs(previousAll, allUnfolded)) {
                return Edge.of(BreakpointStateRejecting.of(allUnfolded, SafetyCoSafety.rejecting(all)));
            }
            if (rejectingUnfolded.isTrue() || SyntacticFragments.isFinite(rejectingUnfolded)) {
                EquivalenceClass nextRejectingUnfolded = rejectingUnfolded.and(SafetyCoSafety.rejecting(all));
                assert (nextRejectingUnfolded.unfold().equals(nextRejectingUnfolded));
                if (nextRejectingUnfolded.isFalse()) {
                    return this.complete ? Edge.of(BreakpointStateRejecting.of(this.factory.of(false))) : null;
                }
                return Edge.of(BreakpointStateRejecting.of(allUnfolded, nextRejectingUnfolded), 0);
            }
            assert (!allUnfolded.isFalse() && !rejectingUnfolded.isFalse());
            assert (!allUnfolded.isTrue() && !rejectingUnfolded.isTrue());
            return Edge.of(BreakpointStateRejecting.of(allUnfolded, rejectingUnfolded));
        }

        private static EquivalenceClass rejecting(EquivalenceClass all) {
            HashSet<XOperator> protectedXOperators;
            EquivalenceClass rejecting = all.substitute(x -> SyntacticFragments.isCoSafety(x) ? x : BooleanConstant.TRUE);
            assert (SyntacticFragments.isCoSafety(rejecting));
            EquivalenceClass xRemovedRejecting = rejecting;
            do {
                rejecting = xRemovedRejecting;
                protectedXOperators = new HashSet<XOperator>();
                for (Formula temporalOperator : rejecting.support(false)) {
                    if (temporalOperator instanceof XOperator) continue;
                    protectedXOperators.addAll(temporalOperator.subformulas(XOperator.class));
                }
            } while (!rejecting.equals(xRemovedRejecting = rejecting.substitute(x -> x instanceof XOperator && !protectedXOperators.contains(x) ? BooleanConstant.TRUE : x)));
            if (SyntacticFragments.isFinite(rejecting.unfold()) && !all.equals(all.unfold())) {
                return SafetyCoSafety.rejecting(all.unfold());
            }
            return rejecting.unfold();
        }
    }

    @AutoValue
    public static abstract class BreakpointStateAccepting {
        public abstract EquivalenceClass all();

        public abstract EquivalenceClass accepting();

        public static BreakpointStateAccepting of(EquivalenceClass all) {
            return new AutoValue_DeterministicConstructions_BreakpointStateAccepting(all, all.factory().of(true));
        }

        public static BreakpointStateAccepting of(EquivalenceClass all, EquivalenceClass accepting) {
            if (all.isTrue()) {
                Preconditions.checkArgument((boolean)accepting.isTrue());
                return BreakpointStateAccepting.of(all.factory().of(true));
            }
            return new AutoValue_DeterministicConstructions_BreakpointStateAccepting(all, accepting);
        }

        public final BreakpointStateAccepting suspend() {
            return this.accepting().isTrue() ? this : BreakpointStateAccepting.of(this.all());
        }

        public final String toString() {
            return String.format("BreakpointStateAccepting{all=%s, accepting=%s}", this.all(), this.accepting().isTrue() ? "[suspended]" : this.accepting());
        }
    }

    public static final class CoSafetySafety
    extends Base<BreakpointStateAccepting, CoBuchiAcceptance> {
        private final SuspensionCheck suspensionCheck;
        private final boolean complete;

        private CoSafetySafety(Factories factories, BreakpointStateAccepting initialState, SuspensionCheck suspensionCheck, boolean complete) {
            super(factories, initialState, CoBuchiAcceptance.INSTANCE);
            this.suspensionCheck = suspensionCheck;
            this.complete = complete;
        }

        public static CoSafetySafety of(Factories factories, Formula formula) {
            return CoSafetySafety.of(factories, formula, false, false);
        }

        public static CoSafetySafety of(Factories factories, Formula formula, boolean complete, boolean deactivateSuspensionCheckOnInitialFormula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isCoSafetySafety(formula));
            EquivalenceClass formulaClass = factories.eqFactory.of(formula);
            SuspensionCheck suspensionCheck = new SuspensionCheck(deactivateSuspensionCheckOnInitialFormula ? factories.eqFactory.of(true) : formulaClass);
            BreakpointStateAccepting initialState = suspensionCheck.isBlocked(formulaClass.unfold()) ? BreakpointStateAccepting.of(formulaClass.unfold()) : BreakpointStateAccepting.of(formulaClass.unfold(), CoSafetySafety.accepting(formulaClass));
            return new CoSafetySafety(factories, initialState, suspensionCheck, complete);
        }

        @Override
        public MtBdd<Edge<BreakpointStateAccepting>> edgeTreeImpl(BreakpointStateAccepting state) {
            return MtBddOperations.cartesianProduct(state.all().temporalStepTree(), state.accepting().temporalStepTree(), (all, accepting) -> this.edge(state.all(), (EquivalenceClass)all, (EquivalenceClass)accepting));
        }

        @Nullable
        private Edge<BreakpointStateAccepting> edge(EquivalenceClass previousAll, EquivalenceClass all, EquivalenceClass accepting) {
            EquivalenceClass allUnfolded = all.unfold();
            if (allUnfolded.isFalse()) {
                return this.complete ? Edge.of(BreakpointStateAccepting.of(this.factory.of(false)), 0) : null;
            }
            if (allUnfolded.isTrue()) {
                return Edge.of(BreakpointStateAccepting.of(allUnfolded.factory().of(true)));
            }
            if (this.suspensionCheck.isBlockedBySafety(allUnfolded)) {
                return Edge.of(BreakpointStateAccepting.of(allUnfolded));
            }
            assert (!allUnfolded.isTrue());
            if (this.suspensionCheck.isBlockedByCoSafety(allUnfolded) || this.suspensionCheck.isBlockedByTransient(allUnfolded)) {
                return Edge.of(BreakpointStateAccepting.of(allUnfolded), 0);
            }
            EquivalenceClass acceptingUnfolded = accepting.unfold();
            if (acceptingUnfolded.isTrue() || BlockingElements.surelyContainedInDifferentSccs(previousAll, allUnfolded)) {
                return Edge.of(BreakpointStateAccepting.of(allUnfolded, CoSafetySafety.accepting(all)), 0);
            }
            if (SyntacticFragments.isFinite(acceptingUnfolded)) {
                EquivalenceClass nextAcceptingUnfolded = acceptingUnfolded.or(CoSafetySafety.accepting(all));
                assert (nextAcceptingUnfolded.unfold().equals(nextAcceptingUnfolded));
                return Edge.of(BreakpointStateAccepting.of(allUnfolded, nextAcceptingUnfolded), 0);
            }
            assert (!allUnfolded.isFalse() && !acceptingUnfolded.isFalse());
            assert (!allUnfolded.isTrue() && !acceptingUnfolded.isTrue());
            return Edge.of(BreakpointStateAccepting.of(allUnfolded, acceptingUnfolded));
        }

        private static EquivalenceClass accepting(EquivalenceClass all) {
            HashSet<XOperator> protectedXOperators;
            EquivalenceClass accepting = all.substitute(x -> SyntacticFragments.isSafety(x) ? x : BooleanConstant.FALSE);
            assert (SyntacticFragments.isSafety(accepting));
            EquivalenceClass xRemovedAccepting = accepting;
            do {
                accepting = xRemovedAccepting;
                protectedXOperators = new HashSet<XOperator>();
                for (Formula formula : accepting.support(false)) {
                    if (formula instanceof XOperator) continue;
                    protectedXOperators.addAll(formula.subformulas(XOperator.class));
                }
            } while (!accepting.equals(xRemovedAccepting = accepting.substitute(x -> x instanceof XOperator && !protectedXOperators.contains(x) ? BooleanConstant.FALSE : x)));
            if (SyntacticFragments.isFinite(accepting.unfold()) && !all.equals(all.unfold())) {
                return CoSafetySafety.accepting(all.unfold());
            }
            return accepting.unfold();
        }
    }

    public static class GfCoSafety
    extends Base<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> {
        private final RoundRobinState<EquivalenceClass> fallbackInitialState;
        private final MtBdd<Pair<List<RoundRobinState<EquivalenceClass>>, ImmutableBitSet>> initialStatesSuccessorTree;

        private GfCoSafety(Factories factories, RoundRobinState<EquivalenceClass> initialState, RoundRobinState<EquivalenceClass> fallbackInitialState, MtBdd<Pair<List<RoundRobinState<EquivalenceClass>>, ImmutableBitSet>> tree, GeneralizedBuchiAcceptance acceptance) {
            super(factories, initialState, acceptance);
            this.fallbackInitialState = fallbackInitialState;
            this.initialStatesSuccessorTree = tree;
        }

        /*
         * WARNING - void declaration
         */
        public static GfCoSafety of(Factories factories, Set<? extends Formula> formulas, boolean generalized) {
            Object initialState;
            void var7_9;
            Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
            EquivalenceClassFactory factory = factories.eqFactory;
            ArrayList<FOperator> automata = new ArrayList<FOperator>();
            ArrayList<Formula> singletonAutomata = new ArrayList<Formula>();
            for (Formula formula : formulas) {
                Preconditions.checkArgument((boolean)SyntacticFragments.isGfCoSafety(formula), (Object)formula);
                Formula unwrapped = Util.unwrap(Util.unwrap(formula));
                if (generalized && SyntacticFragment.SINGLE_STEP.contains(unwrapped)) {
                    singletonAutomata.add(unwrapped);
                    continue;
                }
                automata.add(new FOperator(unwrapped));
            }
            singletonAutomata.sort(Comparator.naturalOrder());
            if (automata.isEmpty()) {
                automata.add(new FOperator((Formula)singletonAutomata.remove(0)));
            } else {
                automata.sort(Comparator.naturalOrder());
            }
            MtBdd initialStatesSuccessorTreeTemp = MtBdd.of(Set.of(List.of()));
            boolean bl = false;
            while (var7_9 < automata.size()) {
                void j = var7_9++;
                initialState = GfCoSafety.initialStateInternal(factory.of((Formula)automata.get((int)j)));
                MtBdd initialStateSuccessorTree = initialState.temporalStepTree().map(arg_0 -> GfCoSafety.lambda$of$1((int)j, arg_0));
                initialStatesSuccessorTreeTemp = MtBddOperations.cartesianProduct(initialStatesSuccessorTreeTemp, initialStateSuccessorTree, Collections3::add);
            }
            MtBdd<Pair<List<RoundRobinState<EquivalenceClass>>, ImmutableBitSet>> mtBdd = MtBddOperations.cartesianProduct(initialStatesSuccessorTreeTemp, Util.singleStepTree(singletonAutomata), (x, y) -> Pair.of(List.copyOf(x), y));
            RoundRobinState<EquivalenceClass> fallbackInitialState = RoundRobinState.of(0, GfCoSafety.initialStateInternal(factory.of((Formula)automata.get(0))));
            initialState = GfCoSafety.buildEdge(0, GfCoSafety.successorInternal(fallbackInitialState.state(), ImmutableBitSet.of()), mtBdd.get(new BitSet()).iterator().next(), fallbackInitialState).successor();
            return new GfCoSafety(factories, (RoundRobinState<EquivalenceClass>)initialState, fallbackInitialState, mtBdd, GeneralizedBuchiAcceptance.of(singletonAutomata.size() + 1));
        }

        private static Edge<RoundRobinState<EquivalenceClass>> buildEdge(int index, EquivalenceClass successor, Pair<List<RoundRobinState<EquivalenceClass>>, ImmutableBitSet> initialStateSuccessors, RoundRobinState<EquivalenceClass> fallbackInitialState) {
            if (!successor.isTrue()) {
                return Edge.of(RoundRobinState.of(index, successor), initialStateSuccessors.snd());
            }
            int size = initialStateSuccessors.fst().size();
            List<RoundRobinState<EquivalenceClass>> latterSuccessors = initialStateSuccessors.fst().subList(index + 1, size);
            for (RoundRobinState<EquivalenceClass> initialStateSuccessor : latterSuccessors) {
                if (initialStateSuccessor.state().isTrue()) continue;
                return Edge.of(initialStateSuccessor, initialStateSuccessors.snd());
            }
            BitSet acceptance = BitSet2.copyOf(initialStateSuccessors.snd());
            acceptance.set(0);
            List<RoundRobinState<EquivalenceClass>> earlierSuccessors = initialStateSuccessors.fst().subList(0, index + 1);
            for (RoundRobinState<EquivalenceClass> initialStateSuccessor : earlierSuccessors) {
                if (initialStateSuccessor.state().isTrue()) continue;
                return Edge.of(initialStateSuccessor, acceptance);
            }
            return Edge.of(fallbackInitialState, acceptance);
        }

        @Override
        public final MtBdd<Edge<RoundRobinState<EquivalenceClass>>> edgeTreeImpl(RoundRobinState<EquivalenceClass> state) {
            MtBdd<EquivalenceClass> successorTree = GfCoSafety.successorTreeInternal(state.state());
            return MtBddOperations.cartesianProduct(successorTree, this.initialStatesSuccessorTree, (x, y) -> GfCoSafety.buildEdge(state.index(), x, y, this.fallbackInitialState));
        }

        @Override
        public final boolean is(Automaton.Property property) {
            if (property == Automaton.Property.COMPLETE) {
                return true;
            }
            return super.is(property);
        }
    }

    public static final class Tracking
    extends Base<EquivalenceClass, AllAcceptance> {
        public Tracking(Factories factories) {
            super(factories, factories.eqFactory.of(BooleanConstant.TRUE), AllAcceptance.INSTANCE);
        }

        public EquivalenceClass asInitialState(Formula state) {
            EquivalenceClass initialState = this.factory.of(state).unfold();
            if (initialState.isTrue()) {
                return initialState.factory().of(true);
            }
            if (initialState.isFalse()) {
                return initialState.factory().of(false);
            }
            return initialState;
        }

        public MtBdd<EquivalenceClass> successorTree(EquivalenceClass clazz) {
            return clazz.temporalStepTree().map(x -> Collections3.transformSet(x, y -> {
                EquivalenceClass yUnfold = y.unfold();
                if (yUnfold.isFalse()) {
                    return this.factory.of(false);
                }
                if (yUnfold.isTrue()) {
                    return this.factory.of(true);
                }
                return yUnfold;
            }));
        }

        @Override
        public MtBdd<Edge<EquivalenceClass>> edgeTreeImpl(EquivalenceClass clazz) {
            return clazz.temporalStepTree().map(x -> Collections3.transformSet(x, y -> {
                EquivalenceClass yUnfold = y.unfold();
                if (yUnfold.isFalse()) {
                    return Edge.of(this.factory.of(false));
                }
                if (yUnfold.isTrue()) {
                    return Edge.of(this.factory.of(true));
                }
                return Edge.of(yUnfold);
            }));
        }
    }

    public static final class Safety
    extends Looping<AllAcceptance> {
        private Safety(Factories factories, Formula formula) {
            super(factories, formula, AllAcceptance.INSTANCE);
        }

        public static Safety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isSafety(formula), (Object)formula);
            return new Safety(factories, formula);
        }

        @Override
        @Nullable
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor) {
            return successor.isFalse() ? null : Edge.of(successor);
        }

        public EquivalenceClass onlyInitialStateWithRemainder(EquivalenceClass remainder) {
            return ((EquivalenceClass)this.initialState()).and(Safety.initialStateInternal(remainder));
        }
    }

    public static final class CoSafety
    extends Looping<BuchiAcceptance> {
        private CoSafety(Factories factories, Formula formula) {
            super(factories, formula, BuchiAcceptance.INSTANCE);
        }

        public static CoSafety of(Factories factories, Formula formula) {
            Preconditions.checkArgument((boolean)SyntacticFragments.isCoSafety(formula), (Object)formula);
            return new CoSafety(factories, formula);
        }

        @Override
        @Nullable
        protected Edge<EquivalenceClass> buildEdge(EquivalenceClass successor) {
            if (successor.isFalse()) {
                return null;
            }
            return successor.isTrue() ? Edge.of(successor.factory().of(true), 0) : Edge.of(successor);
        }
    }

    private static abstract class Looping<A extends EmersonLeiAcceptance>
    extends Base<EquivalenceClass, A> {
        private Looping(Factories factories, Formula formula, A acceptance) {
            super(factories, Looping.initialStateInternal(factories.eqFactory.of(formula)), acceptance);
        }

        @Override
        public final MtBdd<Edge<EquivalenceClass>> edgeTreeImpl(EquivalenceClass clazz) {
            return clazz.temporalStepTree().map(x -> Collections3.ofNullable(this.buildEdge(((EquivalenceClass)Iterables.getOnlyElement((Iterable)x)).unfold())));
        }

        @Nullable
        protected abstract Edge<EquivalenceClass> buildEdge(EquivalenceClass var1);
    }

    static abstract class Base<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<S, A> {
        final EquivalenceClassFactory factory;

        Base(Factories factories, S initialState, A acceptance) {
            super(factories.eqFactory.atomicPropositions(), factories.vsFactory, Set.of(initialState), acceptance);
            this.factory = factories.eqFactory;
        }

        @Override
        public boolean is(Automaton.Property property) {
            if (property == Automaton.Property.DETERMINISTIC || property == Automaton.Property.SEMI_DETERMINISTIC || property == Automaton.Property.LIMIT_DETERMINISTIC) {
                return true;
            }
            return super.is(property);
        }

        static EquivalenceClass initialStateInternal(EquivalenceClass clazz) {
            return clazz.unfold();
        }

        static EquivalenceClass successorInternal(EquivalenceClass clazz, BitSet valuation) {
            return clazz.temporalStep(valuation).unfold();
        }

        static EquivalenceClass successorInternal(EquivalenceClass clazz, ImmutableBitSet valuation) {
            return Base.successorInternal(clazz, BitSet2.copyOf(valuation));
        }

        static MtBdd<EquivalenceClass> successorTreeInternal(EquivalenceClass clazz) {
            return clazz.temporalStepTree().map(preSuccessors -> Collections3.transformSet(preSuccessors, EquivalenceClass::unfold));
        }
    }
}

