/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.dra2dpa;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.SingletonAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.optimization.ParityAcceptanceOptimizations;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.bdd.MtBdd;
import owl.collections.Collections3;
import owl.collections.IntPreOrder;
import owl.translations.dra2dpa.IARState;

public final class IARBuilder<R> {
    private final Automaton<R, ? extends RabinAcceptance> rabinAutomaton;
    private final ParityAcceptance.Parity parity;

    public IARBuilder(Automaton<R, ? extends RabinAcceptance> rabinAutomaton, ParityAcceptance.Parity parity) {
        this.rabinAutomaton = rabinAutomaton;
        this.parity = parity;
    }

    public Automaton<IARState<R>, ParityAcceptance> build() {
        int rejectingPriority;
        if (this.rabinAutomaton.initialStates().isEmpty()) {
            return EmptyAutomaton.of(this.rabinAutomaton.atomicPropositions(), new ParityAcceptance(1, this.parity));
        }
        RabinAcceptance rabinAcceptance = this.rabinAutomaton.acceptance();
        Set<GeneralizedRabinAcceptance.RabinPair> rabinPairs = Set.copyOf(rabinAcceptance.pairs());
        int n = rejectingPriority = this.parity.even() ? 1 : 0;
        if (rabinPairs.isEmpty()) {
            R rabinState = this.rabinAutomaton.initialStates().iterator().next();
            ParityAcceptance acceptance = new ParityAcceptance(this.parity.even() ? 2 : 1, this.parity);
            return SingletonAutomaton.of(this.rabinAutomaton.atomicPropositions(), IARState.of(rabinState), acceptance, acceptance.rejectingSet().orElseThrow());
        }
        HashMultimap stateMap = HashMultimap.create();
        ParityAcceptance acceptance = new ParityAcceptance(0, this.parity);
        HashMapAutomaton<IARState<R>, ParityAcceptance> resultAutomaton = HashMapAutomaton.create(this.rabinAutomaton.atomicPropositions(), this.rabinAutomaton.factory(), acceptance);
        List<Set<R>> decomposition = SccDecomposition.of(this.rabinAutomaton).sccsWithoutTransient();
        HashSet<R> missingStates = new HashSet<R>(this.rabinAutomaton.states());
        decomposition.forEach(missingStates::removeAll);
        for (Set<R> set : decomposition) {
            HashSet<GeneralizedRabinAcceptance.RabinPair> noInfEdgePairs = new HashSet<GeneralizedRabinAcceptance.RabinPair>(rabinPairs);
            for (Object state : set) {
                for (Edge<R> edge2 : this.rabinAutomaton.edges(state)) {
                    noInfEdgePairs.removeIf(pair -> edge2.colours().contains(pair.infSet()));
                }
            }
            Set<GeneralizedRabinAcceptance.RabinPair> set2 = Set.copyOf(Sets.difference(rabinPairs, noInfEdgePairs));
            if (set2.isEmpty()) {
                Object state;
                for (Object e : set) {
                    IARState iarState = IARState.of(e);
                    resultAutomaton.addState(iarState);
                    stateMap.put(e, iarState);
                }
                state = set.iterator();
                while (state.hasNext()) {
                    Object e = state.next();
                    this.rabinAutomaton.edgeMap(e).forEach((edge, valuation) -> {
                        if (scc.contains(edge.successor())) {
                            resultAutomaton.addEdge((IARState)IARState.of(state2), (BddSet)valuation, (Edge)Edge.of(IARState.of(edge.successor()), rejectingPriority));
                        }
                    });
                }
                continue;
            }
            Views.Filter<Object> sccFilter = Views.Filter.of(Set.of(set.iterator().next()), set::contains);
            Automaton<Object, ? extends RabinAcceptance> automaton = Views.filtered(this.rabinAutomaton, sccFilter);
            MutableAutomaton<IARState<Object>, ParityAcceptance> subAutomaton = this.build(automaton, set2);
            MutableAutomatonUtil.copyInto(subAutomaton, resultAutomaton);
            subAutomaton.states().forEach(arg_0 -> IARBuilder.lambda$build$2((Multimap)stateMap, arg_0));
            assert (subAutomaton.states().stream().map(IARState::state).collect(Collectors.toSet()).equals(set));
        }
        for (Set<Object> set : missingStates) {
            IARState<Set<Object>> iarState = IARState.of(set);
            resultAutomaton.addState(iarState);
            stateMap.put(set, iarState);
        }
        for (Set<Object> set : decomposition) {
            for (Object e : set) {
                Collection iarStates = stateMap.get(e);
                this.rabinAutomaton.edgeMap(e).forEach((arg_0, arg_1) -> IARBuilder.lambda$build$3(set, (Multimap)stateMap, iarStates, resultAutomaton, arg_0, arg_1));
            }
        }
        for (Set<Object> set : missingStates) {
            Collection iarStates = stateMap.get(set);
            this.rabinAutomaton.edgeMap(set).forEach((arg_0, arg_1) -> IARBuilder.lambda$build$4((Multimap)stateMap, iarStates, resultAutomaton, arg_0, arg_1));
        }
        assert (Objects.equals(stateMap.keySet(), this.rabinAutomaton.states()));
        resultAutomaton.initialStates(this.rabinAutomaton.initialStates().stream().map(arg_0 -> ((Multimap)stateMap).get(arg_0)).map(Collection::iterator).map(Iterator::next).collect(Collectors.toSet()));
        resultAutomaton.trim();
        this.optimizeInitialStates(resultAutomaton, false);
        resultAutomaton.trim();
        ParityAcceptanceOptimizations.setAcceptingSets(resultAutomaton);
        return resultAutomaton;
    }

    private void optimizeInitialStates(MutableAutomaton<IARState<R>, ParityAcceptance> automaton, boolean singleScc) {
        SccDecomposition<IARState<R>> sccDecomposition = SccDecomposition.of(automaton);
        List sccs = Lists.reverse(sccDecomposition.sccsWithoutTransient());
        ArrayList<IARState> newInitialStates = new ArrayList<IARState>();
        Set initialStatesToSearch = automaton.initialStates().stream().map(IARState::state).collect(Collectors.toSet());
        Iterable statesToSearch = singleScc ? (Iterable)sccs.stream().filter(sccDecomposition::isBottomScc).findAny().orElseThrow() : Iterables.concat((Iterable)sccs);
        for (IARState state : statesToSearch) {
            Object rabinState = state.state();
            if (!initialStatesToSearch.remove(rabinState)) continue;
            newInitialStates.add(state);
            if (!initialStatesToSearch.isEmpty()) continue;
            break;
        }
        if (!initialStatesToSearch.isEmpty()) {
            assert (!singleScc);
            Set foundInitialStates = newInitialStates.stream().map(IARState::state).collect(Collectors.toSet());
            automaton.initialStates().stream().filter(s -> !foundInitialStates.contains(s.state())).forEach(newInitialStates::add);
        }
        assert (newInitialStates.stream().map(IARState::state).collect(Collectors.toSet()).equals(automaton.initialStates().stream().map(IARState::state).collect(Collectors.toSet())));
        automaton.initialStates(newInitialStates);
        automaton.trim();
    }

    private void optimizeStateRefinement(MutableAutomaton<IARState<R>, ParityAcceptance> automaton) {
        HashMap<Object, Multimap> topElements = new HashMap<Object, Multimap>();
        for (IARState state : automaton.states()) {
            Multimap refinements = topElements.computeIfAbsent(state.state(), k -> ArrayListMultimap.create());
            Iterator iterator = refinements.asMap().entrySet().iterator();
            ArrayList<IntPreOrder> refined = new ArrayList<IntPreOrder>();
            IntPreOrder stateOrder = state.record();
            boolean isTop = true;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                IntPreOrder entryOrder = (IntPreOrder)entry.getKey();
                if (entryOrder.refines(stateOrder)) {
                    ((Collection)entry.getValue()).add(stateOrder);
                    isTop = false;
                    break;
                }
                if (!stateOrder.refines(entryOrder)) continue;
                refined.add(entryOrder);
                refined.addAll((Collection)entry.getValue());
                iterator.remove();
            }
            if (!isTop) continue;
            refined.add(stateOrder);
            refinements.putAll((Object)stateOrder, refined);
        }
        HashBasedTable refinementTable = HashBasedTable.create();
        for (Map.Entry entry : topElements.entrySet()) {
            Object rabinState = entry.getKey();
            Multimap refinements = (Multimap)entry.getValue();
            refinements.forEach((arg_0, arg_1) -> IARBuilder.lambda$optimizeStateRefinement$7((Table)refinementTable, rabinState, arg_0, arg_1));
        }
        automaton.initialStates(automaton.initialStates().stream().map(arg_0 -> IARBuilder.lambda$optimizeStateRefinement$8((Table)refinementTable, arg_0)).collect(Collectors.toSet()));
        automaton.updateEdges((arg_0, arg_1) -> IARBuilder.lambda$optimizeStateRefinement$9((Table)refinementTable, arg_0, arg_1));
        automaton.trim();
    }

    private IARExplorer<R> explorer(Automaton<R, ? extends RabinAcceptance> rabinAutomaton, Set<GeneralizedRabinAcceptance.RabinPair> activeRabinPairs) {
        int numberOfTrackedPairs = activeRabinPairs.size();
        IntPreOrder initialRecord = IntPreOrder.coarsest(numberOfTrackedPairs);
        Set initialStates = rabinAutomaton.initialStates().stream().map(initialRabinState -> IARState.of(initialRabinState, initialRecord)).collect(Collectors.toSet());
        return new IARExplorer<R>(rabinAutomaton, initialStates, activeRabinPairs, this.parity);
    }

    private MutableAutomaton<IARState<R>, ParityAcceptance> build(Automaton<R, ? extends RabinAcceptance> rabinAutomaton, Set<GeneralizedRabinAcceptance.RabinPair> activeRabinPairs) {
        assert (SccDecomposition.of(rabinAutomaton).sccs().size() == 1);
        IARExplorer<R> explorer = this.explorer(rabinAutomaton, activeRabinPairs);
        MutableAutomaton<IARState<R>, ParityAcceptance> resultAutomaton = MutableAutomatonUtil.asMutable(explorer);
        this.optimizeInitialStates(resultAutomaton, true);
        assert (SccDecomposition.of(resultAutomaton).sccs().size() == 1);
        this.optimizeStateRefinement(resultAutomaton);
        return resultAutomaton;
    }

    private static /* synthetic */ Edge lambda$optimizeStateRefinement$9(Table refinementTable, IARState state, Edge edge) {
        IARState successor = (IARState)edge.successor();
        IARState refinedSuccessor = (IARState)refinementTable.get(successor.state(), (Object)successor.record());
        return refinedSuccessor == null ? edge : edge.withSuccessor(refinedSuccessor);
    }

    private static /* synthetic */ IARState lambda$optimizeStateRefinement$8(Table refinementTable, IARState initialState) {
        return Objects.requireNonNullElse((IARState)refinementTable.get(initialState.state(), (Object)initialState.record()), initialState);
    }

    private static /* synthetic */ void lambda$optimizeStateRefinement$7(Table refinementTable, Object rabinState, IntPreOrder precise, IntPreOrder coarse) {
        if (!coarse.equals(precise)) {
            refinementTable.put(rabinState, (Object)coarse, IARState.of(rabinState, precise));
        }
    }

    private static /* synthetic */ void lambda$build$4(Multimap stateMap, Collection iarStates, MutableAutomaton resultAutomaton, Edge edge, BddSet valuation) {
        Object successor = edge.successor();
        IARState successorIar = (IARState)stateMap.get(successor).iterator().next();
        for (IARState iarState : iarStates) {
            resultAutomaton.addEdge(iarState, valuation, Edge.of(successorIar));
        }
    }

    private static /* synthetic */ void lambda$build$3(Set scc, Multimap stateMap, Collection iarStates, MutableAutomaton resultAutomaton, Edge edge, BddSet valuation) {
        Object successor = edge.successor();
        if (!scc.contains(successor)) {
            IARState successorIar = (IARState)stateMap.get(successor).iterator().next();
            for (IARState iarState : iarStates) {
                resultAutomaton.addEdge(iarState, valuation, Edge.of(successorIar));
            }
        }
    }

    private static /* synthetic */ void lambda$build$2(Multimap stateMap, IARState state) {
        stateMap.put(state.state(), (Object)state);
    }

    private static final class IARExplorer<S>
    extends AbstractMemoizingAutomaton.EdgeTreeImplementation<IARState<S>, ParityAcceptance> {
        private final Automaton<S, ? extends RabinAcceptance> rabinAutomaton;
        private final GeneralizedRabinAcceptance.RabinPair[] indexToPair;
        private final ParityAcceptance.Parity parity;

        private IARExplorer(Automaton<S, ? extends RabinAcceptance> rabinAutomaton, Set<IARState<S>> initialStates, Set<GeneralizedRabinAcceptance.RabinPair> trackedPairs, ParityAcceptance.Parity parity) {
            super(rabinAutomaton.atomicPropositions(), rabinAutomaton.factory(), initialStates, new ParityAcceptance(0, parity));
            this.rabinAutomaton = rabinAutomaton;
            this.indexToPair = (GeneralizedRabinAcceptance.RabinPair[])trackedPairs.toArray(GeneralizedRabinAcceptance.RabinPair[]::new);
            this.parity = parity;
        }

        @Override
        public MtBdd<Edge<IARState<S>>> edgeTreeImpl(IARState<S> state) {
            IntPreOrder record = state.record();
            return this.rabinAutomaton.edgeTree(state.state()).map(edges -> Collections3.transformSet(edges, edge -> this.computeSuccessorEdge(record, (Edge<S>)edge)));
        }

        private Edge<IARState<S>> computeSuccessorEdge(IntPreOrder record, Edge<S> rabinEdge) {
            int priority;
            S rabinSuccessor = rabinEdge.successor();
            int classCount = record.classes();
            if (classCount == 0) {
                int priority2 = this.parity.even() ? 1 : 0;
                return Edge.of(IARState.of(rabinEdge.successor()), priority2);
            }
            int matchOffset = 0;
            boolean infMatch = false;
            BitSet seenFin = new BitSet();
            int currentOffset = 0;
            for (int currentClass = 0; currentClass < classCount; ++currentClass) {
                int[] classes = record.equivalenceClass(currentClass);
                currentOffset += classes.length;
                for (int rabinIndex : classes) {
                    GeneralizedRabinAcceptance.RabinPair rabinPair = this.indexToPair[rabinIndex];
                    if (rabinEdge.colours().contains(rabinPair.finSet())) {
                        matchOffset = currentOffset;
                        infMatch = false;
                        seenFin.set(rabinIndex);
                        continue;
                    }
                    if (matchOffset >= currentOffset || !rabinEdge.colours().contains(rabinPair.infSet())) continue;
                    matchOffset = currentOffset;
                    infMatch = true;
                }
            }
            if (this.parity.max()) {
                priority = this.parity.even() ? (matchOffset == 0 ? 1 : (infMatch ? matchOffset * 2 : matchOffset * 2 + 1)) : (matchOffset == 0 ? 0 : (infMatch ? matchOffset * 2 + 1 : matchOffset * 2 + 2));
            } else {
                int inverse = (this.indexToPair.length - matchOffset + 1) * 2;
                if (this.parity.even()) {
                    priority = matchOffset == 0 ? this.indexToPair.length * 2 + 1 : (infMatch ? inverse : inverse - 1);
                } else if (matchOffset == 0) {
                    priority = this.indexToPair.length * 2;
                } else {
                    int n = priority = infMatch ? inverse - 1 : inverse - 2;
                }
            }
            assert (priority >= 0 || matchOffset == 0) : "Negative priority for " + this.parity + ": Match at " + matchOffset + " (" + (infMatch ? "INF" : "FIN") + "), " + this.indexToPair.length;
            IntPreOrder successorRecord = record;
            int i = seenFin.nextSetBit(0);
            while (i >= 0) {
                successorRecord = successorRecord.generation(Set.of(Integer.valueOf(i)));
                if (i == Integer.MAX_VALUE) break;
                i = seenFin.nextSetBit(i + 1);
            }
            IARState<S> successorState = IARState.of(rabinSuccessor, successorRecord);
            return Edge.of(successorState, priority);
        }
    }
}

