/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import owl.automaton.edge.Edge;
import owl.collections.BitSet2;
import owl.collections.HashTrieMap;
import owl.collections.Pair;
import owl.collections.TrieMap;
import owl.translations.nbadet.NbaDet;
import owl.translations.nbadet.NbaDetConf;
import owl.translations.nbadet.NbaDetState;
import owl.translations.nbadet.RankedSlice;

public class SmartSucc<S> {
    private static final Logger logger = Logger.getLogger(NbaDet.class.getName());
    private final NbaDetConf<S> detConf;
    private final NbaDetConf<S> refConf;
    private final TrieMap<BitSet, NbaDetState<S>> existing;
    private final Map<Pair<NbaDetState<S>, BitSet>, Edge<NbaDetState<S>>> cache;
    private final boolean smartSuccEnabled;

    public SmartSucc(NbaDetConf<S> conf) {
        this.detConf = conf;
        this.refConf = conf.withUpdateMode(NbaDetConf.UpdateMode.MUELLER_SCHUPP);
        this.existing = new HashTrieMap<BitSet, NbaDetState<S>>();
        this.cache = new HashMap<Pair<NbaDetState<S>, BitSet>, Edge<NbaDetState<S>>>();
        this.smartSuccEnabled = conf.args().useSmartSucc();
    }

    List<NbaDetState<S>> trieDfs(NbaDetState<S> ref, Pair<BitSet, List<BitSet>> msk, TrieMap<BitSet, NbaDetState<S>> node, BitSet pref, int i, boolean getAll) {
        if (node.isEmpty()) {
            return List.of();
        }
        if (pref.intersects(msk.fst())) {
            return List.of();
        }
        if (i < msk.snd().size() && !BitSet2.without(msk.snd().get(i), pref).isEmpty()) {
            return List.of();
        }
        ArrayList<NbaDetState<S>> ret = new ArrayList<NbaDetState<S>>();
        NbaDetState cand = (NbaDetState)node.get(List.of());
        if (cand != null) {
            BitSet lastMask = msk.snd().get(msk.snd().size() - 1);
            boolean allDown = BitSet2.without(lastMask, pref).isEmpty();
            boolean validMerge = ref.finerOrEqual(cand);
            if (allDown && validMerge) {
                ret.add(cand);
            }
            if (!getAll && !ret.isEmpty()) {
                return ret;
            }
        }
        for (Map.Entry<BitSet, TrieMap<BitSet, NbaDetState<S>>> sucnod : node.subTries().entrySet()) {
            ret.addAll(this.trieDfs(ref, msk, sucnod.getValue(), BitSet2.union(pref, sucnod.getKey()), i + 1, getAll));
            if (getAll || ret.isEmpty()) continue;
            return ret;
        }
        return ret;
    }

    public List<Edge<NbaDetState<S>>> getSuitable(NbaDetState<S> cur, BitSet sym, boolean getAll) {
        Edge<NbaDetState<S>> refSuc = cur.successor(this.refConf, sym);
        Pair<Integer, Boolean> ev = NbaDetState.priorityToRank(refSuc.colours().first().orElse(Integer.MAX_VALUE));
        List<BitSet> th = refSuc.successor().toTrieEncoding();
        int k = ev.fst() + 2;
        if (k > th.size()) {
            k = th.size();
        }
        Pair<BitSet, List<BitSet>> msk = SmartSucc.kCutMask(th, k - 1);
        List<BitSet> tht = th.subList(0, k);
        ArrayList<Edge<NbaDetState<S>>> ret = new ArrayList<Edge<NbaDetState<S>>>();
        if (this.existing.containsKeyWithPrefix(tht)) {
            TrieMap<BitSet, NbaDetState<S>> subtrie = this.existing.subTrie(tht);
            List<NbaDetState<S>> cnds = this.trieDfs(refSuc.successor(), msk, subtrie, tht.get(tht.size() - 1), 0, getAll);
            for (NbaDetState<S> cnd : cnds) {
                ret.add(refSuc.withSuccessor(cnd));
            }
        }
        return ret;
    }

    public void sanityCheckSuccessor(NbaDetState<S> cur, BitSet sym, Edge<NbaDetState<S>> altSuc) {
        Edge<NbaDetState<S>> usrSuc = cur.successor(this.detConf, sym);
        if (usrSuc.equals(altSuc)) {
            return;
        }
        Edge<NbaDetState<S>> refSuc = cur.successor(this.refConf, sym);
        int rk = NbaDetState.priorityToRank(refSuc.colours().first().orElse(Integer.MAX_VALUE)).fst();
        logger.log(Level.FINEST, "dom rank " + rk + " redirect");
        logger.log(Level.FINEST, "from: " + usrSuc.toString() + "\nto: " + altSuc.toString());
        if (!usrSuc.colours().equals(altSuc.colours())) {
            logger.log(Level.SEVERE, "ERROR: edge priority changed!");
        }
        if (!refSuc.successor().finerOrEqual(altSuc.successor())) {
            logger.log(Level.SEVERE, "ERROR: selected is not refinement of MS!");
        }
        if (!SmartSucc.notWorse(altSuc.successor().toTrieEncoding(), refSuc.successor().toTrieEncoding(), rk + 1)) {
            logger.log(Level.SEVERE, "ERROR: states got worse ranks than allowed!");
        }
    }

    public Edge<NbaDetState<S>> successor(NbaDetState<S> cur, BitSet sym) {
        if (!this.smartSuccEnabled) {
            return cur.successor(this.detConf, sym);
        }
        Pair<NbaDetState<S>, BitSet> request = Pair.of(cur, sym);
        if (this.cache.containsKey(request)) {
            return this.cache.get(request);
        }
        List<Edge<NbaDetState<S>>> alt = this.getSuitable(cur, sym, false);
        if (!alt.isEmpty()) {
            Edge<NbaDetState<S>> altSuc = alt.get(0);
            this.cache.put(request, altSuc);
            return altSuc;
        }
        Edge<NbaDetState<S>> newSucc = cur.successor(this.detConf, sym);
        this.existing.put((BitSet)((Object)newSucc.successor().toTrieEncoding()), newSucc.successor());
        this.cache.put(request, newSucc);
        return newSucc;
    }

    public static List<Pair<BitSet, Integer>> unprune(List<Pair<BitSet, Integer>> pruned) {
        ArrayList<Pair<BitSet, Integer>> ret = new ArrayList<Pair<BitSet, Integer>>();
        Stack<Pair<BitSet, Integer>> s = new Stack<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> e : pruned) {
            BitSet tmp = (BitSet)e.fst().clone();
            while (!s.empty() && e.snd() < (Integer)((Pair)s.peek()).snd()) {
                tmp.or((BitSet)((Pair)s.peek()).fst());
                s.pop();
            }
            Pair<BitSet, Integer> el = Pair.of(tmp, e.snd());
            ret.add(el);
            s.push(el);
        }
        return ret;
    }

    public static List<Pair<BitSet, Integer>> prune(List<Pair<BitSet, Integer>> unpruned) {
        ArrayList<Pair<BitSet, Integer>> ret = new ArrayList<Pair<BitSet, Integer>>();
        Stack<Pair<BitSet, Integer>> s = new Stack<Pair<BitSet, Integer>>();
        for (Pair<BitSet, Integer> e : unpruned) {
            BitSet tmp = (BitSet)e.fst().clone();
            while (!s.empty() && e.snd() < (Integer)((Pair)s.peek()).snd()) {
                tmp.andNot((BitSet)((Pair)s.peek()).fst());
                s.pop();
            }
            Pair<BitSet, Integer> el = Pair.of(tmp, e.snd());
            ret.add(el);
            s.push(e);
        }
        return ret;
    }

    public static List<BitSet> toTrieEncoding(RankedSlice rs) {
        List<Pair<BitSet, Integer>> unpruned = SmartSucc.unprune(new ArrayList<Pair<BitSet, Integer>>(rs.slice()));
        unpruned.sort(Comparator.comparing(Pair::snd));
        return unpruned.stream().map(Pair::fst).collect(Collectors.toCollection(ArrayList::new));
    }

    public static RankedSlice fromTrieEncoding(List<BitSet> word) {
        ArrayList<Pair<BitSet, Integer>> wordWithIdx = new ArrayList<Pair<BitSet, Integer>>();
        for (int i = 0; i < word.size(); ++i) {
            wordWithIdx.add(Pair.of(word.get(i), i));
        }
        HashMap<Integer, Integer> parent = new HashMap<Integer, Integer>();
        ArrayList<Integer> roots = new ArrayList<Integer>();
        for (int i = 0; i < word.size(); ++i) {
            int j;
            boolean hasParent = false;
            for (j = i - 1; j >= 0; --j) {
                if (!BitSet2.without(word.get(i), word.get(j)).isEmpty()) continue;
                hasParent = true;
                break;
            }
            if (hasParent) {
                parent.put(i, j);
                continue;
            }
            roots.add(i);
        }
        HashMap children = new HashMap();
        for (int i = 0; i < word.size(); ++i) {
            if (!parent.containsKey(i)) continue;
            Integer j = (Integer)parent.get(i);
            if (!children.containsKey(j)) {
                children.put(j, new ArrayList());
            }
            ((ArrayList)children.get(j)).add(i);
        }
        SuccessorsFunction treeSucc = x -> {
            if (children.containsKey(x)) {
                return (Iterable)children.get(x);
            }
            return new ArrayList();
        };
        ArrayList<Pair<BitSet, Integer>> res = new ArrayList<Pair<BitSet, Integer>>();
        for (Integer root : roots) {
            for (Integer el : Traverser.forTree((SuccessorsFunction)treeSucc).depthFirstPostOrder((Object)root)) {
                res.add((Pair)wordWithIdx.get(el));
            }
        }
        return RankedSlice.of(SmartSucc.prune(res));
    }

    public static boolean finerOrEqual(RankedSlice rs1, RankedSlice rs2) {
        int j;
        if (rs1.slice().isEmpty() && rs2.slice().isEmpty()) {
            return true;
        }
        if (rs1.slice().isEmpty() || rs2.slice().isEmpty()) {
            return false;
        }
        BitSet pref1 = new BitSet();
        BitSet pref2 = new BitSet();
        int i = 0;
        for (j = 0; j < rs2.slice().size(); ++j) {
            pref2.or(rs2.slice().get(j).fst());
            while (i < rs1.slice().size() && BitSet2.without(BitSet2.union(pref1, rs1.slice().get(i).fst()), pref2).isEmpty()) {
                pref1.or(rs1.slice().get(i).fst());
                ++i;
            }
            if (pref1.equals(pref2)) continue;
            return false;
        }
        return i == rs1.slice().size() == (j == rs2.slice().size());
    }

    public static boolean kEquiv(List<BitSet> th1, List<BitSet> th2, int k) {
        if (k >= th1.size() || k >= th2.size()) {
            return false;
        }
        for (int i = 0; i <= k; ++i) {
            if (th1.get(i).equals(th2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Pair<BitSet, List<BitSet>> kCutMask(List<BitSet> th, int k) {
        BitSet forbidden = new BitSet();
        ArrayList<BitSet> masks = new ArrayList<BitSet>();
        BitSet tmp = new BitSet();
        for (int i = k; i < th.size(); ++i) {
            tmp.or(th.get(i));
            masks.add((BitSet)tmp.clone());
        }
        forbidden = BitSet2.without(th.get(0), tmp);
        return Pair.of(forbidden, masks);
    }

    public static boolean notWorse(List<BitSet> th1, List<BitSet> th2, int k) {
        if (!SmartSucc.kEquiv(th1, th2, k)) {
            return false;
        }
        Pair<BitSet, List<BitSet>> msk = SmartSucc.kCutMask(th2, k);
        BitSet tmp = new BitSet();
        for (int i = k; i < th1.size(); ++i) {
            if (th1.get(i).intersects(msk.fst())) {
                return false;
            }
            tmp.or(th1.get(i));
            if (BitSet2.without(msk.snd().get(i - k), tmp).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

