/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleKind;
import net.sourceforge.plantuml.style.Value;

public class StyleBuilder
implements AutomaticCounter {
    private final Map<String, Style> styles = new LinkedHashMap<String, Style>();
    private final SkinParam skinParam;
    private int counter;

    public StyleBuilder(SkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public Collection<String> getAllStyleNames() {
        return Collections.unmodifiableCollection(this.styles.keySet());
    }

    public Style createStyle(String name) {
        Style result = this.styles.get(name);
        if (result == null) {
            return new Style(StyleKind.STEREOTYPE, name, new EnumMap<PName, Value>(PName.class));
        }
        return result;
    }

    public StyleBuilder muteStyle(Style modifiedStyle) {
        LinkedHashMap<String, Style> copy = new LinkedHashMap<String, Style>(this.styles);
        String modifiedName = modifiedStyle.getStyleName();
        Style orig = (Style)copy.get(modifiedName);
        if (orig == null) {
            copy.put(modifiedName, modifiedStyle);
        } else {
            assert (orig.getStyleName().equals(modifiedName));
            Style newStyle = orig.mergeWith(modifiedStyle);
            copy.put(modifiedName, newStyle);
        }
        StyleBuilder result = new StyleBuilder(this.skinParam);
        result.styles.putAll(copy);
        result.counter = this.counter;
        return result;
    }

    public void put(String styleName, Style newStyle) {
        this.styles.put(styleName, newStyle);
    }

    @Override
    public int getNextInt() {
        return ++this.counter;
    }

    public Style getMergedStyle(Collection<String> names) {
        Style result = null;
        for (String string : names) {
            Style tmp = this.createStyle(string);
            if (result == null) {
                result = tmp;
                continue;
            }
            result = result.mergeWith(tmp);
        }
        for (Map.Entry entry : this.styles.entrySet()) {
            if (((String)entry.getKey()).indexOf(43) == -1 || !this.matchAll((String)entry.getKey(), names)) continue;
            result = result.mergeWith((Style)entry.getValue());
        }
        return result;
    }

    private boolean matchAll(String key, Collection<String> names) {
        StringTokenizer st = new StringTokenizer(key, "+");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (names.contains(token)) continue;
            return false;
        }
        return true;
    }
}

